/*{
	"GUID":"43E461FF-BEB3-4ef1-974A-93812CB8D210",
	"INPUTS":[
		{
			"TYPE":"image",
			"FILE":"oldtime.png"
		}
	]
}*/

#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

vec4 INPUTSRC(image2d_t src_data,__global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc).zyxw;
}

vec4 INPUT(image2d_t src_data, vec2 tc)
{
	return read_imagef(src_data, sampler, tc).zyxw;
}


//Do gray level adjust
float DoGrayLevel(vec3 inRGB, float lowLevel, float highLevel)
{
    float range = highLevel - lowLevel;
    float gray = dot(inRGB, (vec3)(0.299f, 0.587f, 0.114f));
    gray = max(gray, lowLevel);
    gray = min(gray, highLevel);
    gray = (gray - lowLevel) / range;
    return gray;
}

void initOffset(float st,float W, float H)
{
	vec2 offset[9] = 
    { 
        (vec2)(-1.0f/W, -1.0f/H), 
        (vec2)(0.0f, -1.0f/H), 
        (vec2)(1.0f/W, -1.0f/H), 
        (vec2)(-1.0f/W,    0.0f), 
        (vec2)(0.0f,    0.0f), 
        (vec2)(1.0f/W,    0.0f), 
        (vec2)(-1.0f/W,  1.0f/H), 
        (vec2)(0.0f,  1.0f/H), 
        (vec2)(1.0f/W,  1.0f/H)
     };
				
    float xInc = st / W;
    float yInc = st / H;
    int loc = 0;
    float startPxlX = -(3.0f / 2.f) * xInc;
    float startPxlY = -(3.0f / 2.f) * yInc;
    float curPxLY = 0.f;
    for(int j = 0; j < 3; j++)
    {
        curPxLY = startPxlY + (float)(j) * yInc;
        for(int i = 0; i < 3; i++)
        {
            offset[j*3+i].x=startPxlX + (float)(i) * xInc;
            offset[j*3+i].y = curPxLY;
            loc+=1;
        }
    }
}

__kernel void MAIN(__read_only image2d_t input1, 
	__read_only image2d_t input2,
	__write_only image2d_t dest_data,
	__global FilterParam* param,
	int alpha)
{
	float iGlobalTime = param->cur_time / param->total_time;
	
	int W = get_global_size(0);
	int H = get_global_size(1);
	int w = get_global_id0( param);
	int h = get_global_id1( param);
	float2 resolution = (float2)(W,H);
	float2 iResolution = resolution;
	int2 gl_FragCoord = (int2)(get_global_id0( param), get_global_id1( param));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 uv = ((vec2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f)) /resolution.xy;
	
    vec4 gaussian;
    vec4 sample[9];
    
	vec2 offset[9] = 
                { 
                        (vec2)(-1.0f/W, -1.0f/H), 
                        (vec2)(0.0f, -1.0f/H), 
                        (vec2)(1.0f/W, -1.0f/H), 
                        (vec2)(-1.0f/W,    0.0f), 
                        (vec2)(0.0f,    0.0f), 
                        (vec2)(1.0f/W,    0.0f), 
                        (vec2)(-1.0f/W,  1.0f/H), 
                        (vec2)(0.0f,  1.0f/H), 
                        (vec2)(1.0f/W,  1.0f/H)
                };
				
	initOffset(2.,W, H);			
    for (int i = 0; i < 9; i++)
    {
        // Sample a grid around and including our texel
        sample[i] = INPUTSRC(input1, param, uv + offset[i]);
    }

    // Gaussian weighting:
    // 1  4  7  4 1
    // 4 16 26 16 4
    // 7 26 41 26 7 / 273 (i.e. divide by total of weightings)
    // 4 16 26 16 4
    // 1  4  7  4 1

    gaussian = ( (16.0f  * (sample[0] + sample[2]  + sample[6] + sample[8])) +
                 (26.0f  * (sample[1] + sample[3]  + sample[5] + sample[7])) +
                 (41.0f *  sample[4]) ) / (4.0f * 16.0f + 4.0f * 26.0f + 41.0f);

    vec4 original = sample[4];

    
    //Level adjust
    float levelAdjust = DoGrayLevel(original.xyz, 50.0f/255.0f, 200.0f/255.0f);

    //Blending
    gaussian = (gaussian + levelAdjust) / 2.0f;
    
    gaussian.w = original.w;
    vec4 border = INPUT(input2, (vec2)(uv.x, 1.0f - uv.y));
	vec4 tuneColor = mix(gaussian, border, border.w);
	vec4 inColor = INPUTSRC(input1, param, uv);
	write_imagef(dest_data,  (int2)(get_global_id(0), get_global_id(1)), inColor.zyxw*(1.0f - alpha/100.0f) + (float4)(tuneColor.zyx, inColor.w)*alpha/100.0f);
}
